-- new script file

local waveValley = {}
local mission = {}

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
		mission.enemy = Citadels.GetPlayer(1)
		
    if not self.loaded then
			self.active = false
			self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
		end      
    
    self.valleyWave:LinkToTarget("retHandler")
	  self.wayPoint1 = Game:GetEntity("churchSmall"):GetPosition()
    self.wayPoint2 = Game:GetEntity("gateNorth"):GetPosition()
    self.wayPoint3 = Game:GetEntity("outerCastle"):GetPosition()
  end
  
  if self.active then
    InitializeWave(self)
    AttackWave(self)
		self.valleyWave:TriggerAllTargets()
    self.active = false
  end  
end

function InitializeWave(self)
  waveValley['unit_L_archer_L3'] = self.baseCount * 0.20
  waveValley['unit_L_fman_L2'] = self.baseCount * 0.25
  waveValley['unit_L_fman_L3'] = self.baseCount * 0.15
  waveValley['unit_L_rider_L2'] = self.baseCount * 0.30
  waveValley['unit_L_catapult_L2'] = self.baseCount * 0.06
  waveValley['unit_L_ram_L1'] = self.baseCount * 0.02
end

function AttackWave(self)
  for prefab,ammount in pairs(waveValley) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint1)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint2)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(), 20)
end

function OnTrigger(self, source, target)
  if target == "attValley" then
    Debug:Log("Triggered: " .. target)
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
		self.active = ar:Read()
		self.baseCount = ar:Read()
  elseif (ar:IsSaving()) then
		ar:Write(self.active)
		ar:Write(self.baseCount)
	end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("attValley")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("valleyWave")
end
